#include <stdio.h>
#include <stdlib.h>
#include <sys/time.h>
#include <math.h>

int main(int argc, char * argv[]) 
{
	if(argc<3){
		printf("Invalid input \nFirst argument should be path to test data file, Data format should be as used by LDKL dense data format \nSecond argument should be path to Model file. Model file should have w vector (row vector) values all in a line and separated by space \nThird argument should be number of validation iterations. If input for number of validation iteration is n, code will do prediction n times and return average time\n");
		return(0);
	}
	
	
	//Reading test data from file
	FILE * fin_data = fopen(argv[1],"r");
	int num_ftr;
	long num_tp;
	fscanf(fin_data, "%ld", &num_tp);
	fscanf(fin_data, "%d", &num_ftr);
	int lbl[num_tp];
	int op[num_tp];
	double *ftr;
	long sz=num_tp*num_ftr;
	ftr = malloc(sizeof(double)*sz);
	int i,j;
	for(i=0; i<num_tp; i++){
		fscanf(fin_data,"%d",&lbl[i]);
		for (j=0;j<num_ftr;j++)
			fscanf(fin_data,"%lf",&ftr[i*num_ftr+j]);
	}
	fclose(fin_data);
	printf("Data file loaded\n");
	
	
	
	//Reading w vector from model file
	FILE * fin_model = fopen(argv[2],"r");
	double w[num_ftr];
	for(i=0;i<num_ftr;i++)
		fscanf(fin_model,"%lf",&w[i]);
	fclose(fin_model);
	
	//Doing the prediction stuff
	double sum_tp[num_tp];
	struct timeval timer[2];
	int n=atoi(argv[3]);
	double p_time[n];
	double p_time_sq[n];
	double p_time_sum=0;
	double p_time_sq_sum=0;
	int vld;
	for(vld=0;vld<n;vld++){
		gettimeofday(&timer[0], NULL);
		for(i=0;i<num_tp;i++){	//Making the prediction
			double sum=0;
			for(j=0;j<num_ftr;j++){
				sum=sum+w[j]*ftr[i*num_ftr+j];
			}
			sum_tp[i]=sum;
		}
		gettimeofday(&timer[1], NULL);
		double secs = (timer[1].tv_sec - timer[0].tv_sec);
		double usecs = (timer[1].tv_usec - timer[0].tv_usec);
		if(usecs < 0) {
			--secs;
			usecs += 1000000;
		}
		double prediction_time= (secs * 1000 + usecs / 1000.0);
		printf("Prediction Time: %f mili seconds, exp: %d\n",prediction_time,vld);
		p_time[vld]=prediction_time;
		p_time_sum+=prediction_time;
		p_time_sq_sum+=prediction_time*prediction_time;
		p_time_sq[vld]=prediction_time*prediction_time;
	}
	
	
	for (i=0;i<num_tp;i++){
		if(sum_tp[i]<0)
			op[i]=1;
		else
			op[i]=-1;
		}
	
	int correct=0;
	for (i=0;i<num_tp;i++){
		if(lbl[i]==op[i])
			correct++;
	}
	printf("Prediction Accuracy is: %f percent\n",correct*100.0/num_tp);
	p_time_sum=p_time_sum/n;
	p_time_sq_sum=p_time_sq_sum/n;
	
	double std=sqrt(p_time_sq_sum-p_time_sum*p_time_sum);
	printf("Mean Prediction Time is: %f and std dev is: %f\n",p_time_sum,std);
	
	
	return(0);
	
	

	
}




